% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_bbdml.R
\name{plot.bbdml}
\alias{plot.bbdml}
\title{Plotting function}
\usage{
\method{plot}{bbdml}(
  x,
  total = FALSE,
  color = NULL,
  shape = NULL,
  facet = NULL,
  title = NULL,
  B = 1000,
  sample_names = TRUE,
  data_only = FALSE,
  ...
)
}
\arguments{
\item{x}{Object of class \code{bbdml}.}

\item{total}{(Optional). Default \code{FALSE}. Boolean indicator for whether to plot on total counts scale}

\item{color}{(Optional). Default \code{NULL}. The sample variable to map to different colors. Can be a single character string of the variable name in \code{sample_data} or a custom supplied vector with length equal to the number of samples. Use a character vector to have \code{ggplot2} default.}

\item{shape}{(Optional). Default \code{NULL}. The sample variable to map to different shapes. Can be a single character string of the variable name in \code{sample_data} or a custom supplied vector with length equal to the number of samples.}

\item{facet}{(Optional). Default \code{NULL}. The sample variable to map to different panels in a facet grid. Must be a single character string of a variable name in \code{sample_data}.}

\item{title}{(Optional). Default \code{NULL}. Character string. The main title for the graphic.}

\item{B}{(Optional). Default \code{1000}. Integer. Number of bootstrap simulations for prediction intervals. Use \code{B = 0} for no prediction intervals.}

\item{sample_names}{(Optional). Default \code{TRUE}. Boolean. If \code{FALSE}, remove sample names from the plot.}

\item{data_only}{(Optional). Default \code{FALSE}. Boolean. If \code{TRUE}, only returns data frame.}

\item{...}{There are no optional parameters at this time.}
}
\value{
Object of class \code{ggplot}. Plot of \code{bbdml} model fit with 95% prediction intervals.
}
\description{
Plotting function
}
\examples{
data(soil_phylum_small)
mod <- bbdml(formula = OTU.1 ~ DayAmdmt,
phi.formula = ~ DayAmdmt,
data = soil_phylum_small)
# Here we use B = 50 for quick demonstration purposes.
# In practice, we recommend a higher value for B for more accurate intervals
plot(mod, color = "DayAmdmt", B = 50)
}
