% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.r
\name{count_tcorpus}
\alias{count_tcorpus}
\title{Count results of search hits, or of a given feature in tokens}
\usage{
count_tcorpus(tc, meta_cols = NULL, hits = NULL, feature = NULL,
  count = c("documents", "tokens", "hits"), wide = T)
}
\arguments{
\item{tc}{A tCorpus}

\item{meta_cols}{The columns in the meta data by which the results should be grouped}

\item{hits}{featureHits or contextHits (output of \code{\link{search_features}}, \code{\link{search_dictionary}} or \code{\link{search_contexts}})}

\item{feature}{Instead of hits, a specific feature column can be selected.}

\item{count}{How should the results be counted? Number of documents, tokens, or unique hits. The difference between tokens and hits is that hits can encompass multiple tokens (e.g., "Bob Smith" is 1 hit and 2 tokens).}

\item{wide}{Should results be in wide or long format?}
}
\value{
A data table
}
\description{
Count results of search hits, or of a given feature in tokens
}
\examples{
\donttest{
tc = create_tcorpus(sotu_texts, doc_col='id')
hits = search_features(tc, c("US# <united states>", "Economy# econom*"))
count_tcorpus(tc, hits=hits)
count_tcorpus(tc, hits=hits, meta_cols='president')
count_tcorpus(tc, hits=hits, meta_cols='president', wide=FALSE)
}
}
