% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_tcorpus.r
\name{subset_query}
\alias{subset_query}
\title{Subset tCorpus token data using a query}
\usage{
subset_query(tc, query, feature = "token",
  context_level = c("document", "sentence"), window = NA)
}
\arguments{
\item{tc}{A \code{\link{tCorpus}}}

\item{query}{A character string that is a query. See \link{search_contexts} for query syntax.}

\item{feature}{The name of the feature columns on which the query is used.}

\item{context_level}{Select whether the query and subset are performed at the document or sentence level.}

\item{window}{If used, uses a word distance as the context (overrides context_level)}
}
\description{
A convenience function that searches for contexts (documents, sentences), and uses the results to \link[=subset]{subset} the tCorpus token data.
}
\details{
See the documentation for \link[=search_contexts]{search_contexts} for an explanation of the query language.
}
\examples{
text = c('A B C', 'D E F. G H I', 'A D', 'GGG')
tc = create_tcorpus(text, doc_id = c('a','b','c','d'), split_sentences = TRUE)

## subset by reference
tc2 = subset_query(tc, 'A')
tc2$meta

}
