% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resampled_ttest.R
\name{resampled_ttest}
\alias{resampled_ttest}
\title{Compute correlated t-statistic and p-value for resampled data}
\usage{
resampled_ttest(x, y, n, n1, n2, tailed = c("two", "one"), greater = NULL)
}
\arguments{
\item{x}{\code{numeric} vector of values for model A}

\item{y}{\code{numeric} vector of values for model B}

\item{n}{\code{integer} denoting number of repeat samples. Defaults to \code{length(x)}}

\item{n1}{\code{integer} denoting train set size}

\item{n2}{\code{integer} denoting test set size}

\item{tailed}{\code{character} denoting whether to perform a two-tailed or one-tailed test. Can be one of \code{"two"} or \code{"one"}. Defaults to \code{"two"}}

\item{greater}{\code{character} specifying whether \code{"x"} or \code{"y"} is greater for the one-tailed test if \code{tailed = "one"}. Defaults to \code{NULL}}
}
\value{
\code{data.frame} containing the test statistic and p-value
}
\description{
Compute correlated t-statistic and p-value for resampled data
}
\examples{
x <- rnorm(100, mean = 95, sd = 0.5)
y <- rnorm(100, mean = 90, sd = 1)
resampled_ttest(x = x, y = y, n = 100, n1 = 80, n2 = 20, tailed = "two")

}
\references{
Nadeau, C., and Bengio, Y. Inference for the Generalization Error. Machine Learning 52, (2003).

Bouckaert, R. R., and Frank, E. Evaluating the Replicability of Significance Tests for Comparing Learning Algorithms. Advances in Knowledge Discovery and Data Mining. PAKDD 2004. Lecture Notes in Computer Science, 3056, (2004).
}
\author{
Trent Henderson
}
