% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_to_pcor.R, R/cor_to_spcor.R
\name{cor_to_pcor}
\alias{cor_to_pcor}
\alias{pcor_to_cor}
\alias{cor_to_spcor}
\title{Correlation Matrix to (Semi) Partial Correlations}
\usage{
cor_to_pcor(cor, tol = .Machine$double.eps^(2/3))

pcor_to_cor(pcor, tol = .Machine$double.eps^(2/3))

cor_to_spcor(cor = NULL, cov = NULL, tol = .Machine$double.eps^(2/3))
}
\arguments{
\item{cor, pcor}{A correlation matrix, or a partial or a semipartial
correlation matrix.}

\item{tol}{Relative tolerance to detect zero singular values.}

\item{cov}{A covariance matrix (or a vector of the SD of the variables).
Required for semi-partial correlations.}
}
\value{
The (semi) partial correlation matrix.
}
\description{
Convert a correlation matrix to a (semi)partial correlation matrix. Partial
correlations are a measure of the correlation between two variables that
remains after controlling for (i.e., "partialling" out) all the other
relationships. They can be used for graphical Gaussian models, as they
represent the direct interactions between two variables, conditioned on all
remaining variables. This means that the squared partial correlation between
a predictor X1 and a response variable Y can be interpreted as the proportion
of (unique) variance accounted for by X1 relative to the residual or
unexplained variance of Y that cannot be accounted by the other variables.
}
\details{
The semi-partial correlation is similar to the partial correlation statistic.
However, it represents (when squared) the proportion of (unique) variance
accounted for by the predictor X1, relative to the total variance of Y. Thus,
it might be seen as a better indicator of the "practical relevance" of a
predictor, because it is scaled to (i.e., relative to) the total variability
in the response variable.
}
\examples{
cor <- cor(iris[1:4])

# Partialize
cor_to_pcor(cor)
cor_to_spcor(cor, cov = sapply(iris[1:4], sd))

# Inverse
round(pcor_to_cor(cor_to_pcor(cor)) - cor, 2) # Should be 0
}
