% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_sort.R
\name{cor_sort}
\alias{cor_sort}
\title{Sort a correlation matrix to improve readability of groups and clusters}
\usage{
cor_sort(x, distance = "correlation", ...)
}
\arguments{
\item{x}{A correlation matrix.}

\item{distance}{How the distance between each variable should be calculated.
If \code{correlation} (default; suited for correlation matrices), the matrix
will be rescaled to 0-1 (\code{distance = 0} indicating correlation of \code{1};
\code{distance = 1} indicating correlation of \code{-1}). If \code{raw}, then the matrix
will be used as a distance matrix as-is. Can be others (\code{euclidean},
\code{manhattan}, ...), in which case it will be passed to \code{dist()} (see the
arguments for it).}

\item{...}{Other arguments to be passed to or from other functions.}
}
\description{
Sort a correlation matrix based on \code{hclust}.
}
\examples{
x <- correlation(mtcars)

cor_sort(as.matrix(x))
cor_sort(x, hclust_method = "ward.D2") # It can also reorder the long form output
cor_sort(summary(x, redundant = TRUE)) # As well as from the summary
}
