% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlate.R
\name{correlate}
\alias{correlate}
\title{Correlation Data Frame}
\usage{
correlate(x, y = NULL, use = "pairwise.complete.obs",
  method = "pearson", diagonal = NA, quiet = FALSE)
}
\arguments{
\item{x}{a numeric vector, matrix or data frame.}

\item{y}{\code{NULL} (default) or a vector, matrix or data frame with
    compatible dimensions to \code{x}.   The default is equivalent to
    \code{y = x} (but more efficient).}

\item{use}{an optional character string giving a
    method for computing covariances in the presence
    of missing values.  This must be (an abbreviation of) one of the strings
    \code{"everything"}, \code{"all.obs"}, \code{"complete.obs"},
    \code{"na.or.complete"}, or \code{"pairwise.complete.obs"}.}

\item{method}{a character string indicating which correlation
    coefficient (or covariance) is to be computed.  One of
    \code{"pearson"} (default), \code{"kendall"}, or \code{"spearman"}:
    can be abbreviated.}

\item{diagonal}{Value (typically numeric or NA) to set the diagonal to.}

\item{quiet}{Set as TRUE to suppress message about `method` and `use`
parameters.}
}
\value{
A correlation data frame (cor_df)
}
\description{
An implementation of stats::cor(), which returns a correlation data frame
rather than a matrix. See details below. Additional adjustment include the
use of pairwise deletion by default.
}
\details{
\itemize{
  This function returns a correlation matrix as a correlation data frame in
  the following format:
  \item A tibble (see \code{\link[tibble]{tibble}})
  \item An additional class, "cor_df"
  \item A "rowname" column
  \item Standardized variances (the matrix diagonal) set to missing values by
  default (\code{NA}) so they can be ignored in calculations.
}
}
\examples{
\dontrun{
correlate(iris)
}

correlate(iris[-5])

correlate(mtcars)

\dontrun{

# Also supports DB backend and collects results into memory

library(sparklyr)
sc <- spark_connect(master = "local")
mtcars_tbl <- copy_to(sc, mtcars)
mtcars_tbl \%>\% 
  correlate(use = "pairwise.complete.obs", method = "spearman")
spark_disconnect(sc)

}

}
