% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{rplot}
\alias{rplot}
\title{Plot a correlation data frame.}
\usage{
rplot(
  rdf,
  legend = TRUE,
  shape = 16,
  colours = c("indianred2", "white", "skyblue1"),
  print_cor = FALSE,
  colors,
  .order = c("default", "alphabet")
)
}
\arguments{
\item{rdf}{Correlation data frame (see \code{\link{correlate}}) or object
that can be coerced to one (see \code{\link{as_cordf}}).}

\item{legend}{Boolean indicating whether a legend mapping the colors to the
correlations should be displayed.}

\item{shape}{\code{\link{geom_point}} aesthetic.}

\item{colours, colors}{Vector of colors to use for n-color gradient.}

\item{print_cor}{Boolean indicating whether the correlations should be
printed over the shapes.}

\item{.order}{Either "default", meaning x and y variables keep the same order
as the columns in \code{x}, or "alphabet", meaning the variables are
alphabetized.}
}
\value{
Plots a correlation data frame
}
\description{
Plot a correlation data frame using ggplot2.
}
\details{
Each value in the correlation data frame is represented by one point/circle
in the output plot. The size of each point corresponds to the absolute value
of the correlation (via the \code{size} aesthetic). The color of each point
corresponds to the signed value of the correlation (via the \code{color}
aesthetic).
}
\examples{
x <- correlate(mtcars)
rplot(x)

# Common use is following rearrange and shave
x <- rearrange(x, absolute = FALSE)
x <- shave(x)
rplot(x)
rplot(x, print_cor = TRUE)
rplot(x, shape = 20, colors = c("red", "green"), legend = TRUE)
}
