% Generated by roxygen2 (4.0.1): do not edit by hand
\name{cosinor.lm.default}
\alias{cosinor.lm.default}
\title{Fit cosinor model}
\usage{
cosinor.lm.default(formula, ...)
}
\arguments{
\item{formula}{Forumla specifying the model. Indicate the time variable with \code{time()} and covariate effects on the
amplitude and acrophase with \code{amp.acro()}. See details.}

\item{...}{other arguments}
}
\description{
Given an outcome and time variable, fit the cosinor model with optional covariate effects.
}
\details{
This defines special functions that are used in the formula to indicate the time variable
and which covariates effect the amplitude. To indicate the time variable wrap the name of it in the function
\code{time()}. To indicate a variable which affects the acrophase/amplitude, wrap the name in
\code{amp.acro()}. This will then do all the tranformations for you. See examples for usage.
}
\examples{
cosinor.lm(Y ~ time(time) + X + amp.acro(X), data = vitamind)
}

