% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosinor2.R
\name{cosinor.PR}
\alias{cosinor.PR}
\title{Percent Rhythm}
\usage{
cosinor.PR(x)
}
\arguments{
\item{x}{An object of the \code{cosinor.lm} or \code{population.cosinor.lm} class.}
}
\description{
Calculates Percent Rhythm, the measure of the relative strength of a rhythm.
}
\details{
Percent Rhythm is the coefficient of determination obtained by squaring the correlation between observed and estimated values.
}
\examples{
fit.temperature<-cosinor.lm(Temperature~time(Time), period = 24, data = temperature_zg)
cosinor.PR(fit.temperature)

fit.november<-population.cosinor.lm(data = PANAS_november, time = PANAS_time,
period = 7)
cosinor.PR(fit.november)
}
