% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{g_bc}
\alias{g_bc}
\title{Box-Cox transformation}
\usage{
g_bc(t, lambda)
}
\arguments{
\item{t}{argument(s) at which to evaluate the function}

\item{lambda}{Box-Cox parameter}
}
\value{
The evaluation(s) of the Box-Cox function at the given input(s) \code{t}.
}
\description{
Evaluate the Box-Cox transformation, which is a scaled power transformation
to preserve continuity in the index \code{lambda} at zero. Negative values are
permitted.
}
\note{
Special cases include
the identity transformation (\code{lambda = 1}),
the square-root transformation (\code{lambda = 1/2}),
and the log transformation (\code{lambda = 0}).
}
\examples{
# Log-transformation:
g_bc(1:5, lambda = 0); log(1:5)

# Square-root transformation: note the shift and scaling
g_bc(1:5, lambda = 1/2); sqrt(1:5)

}
