% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_colors_in_images.R
\name{countColors}
\alias{countColors}
\title{Count the number of pixels within a color range or ranges}
\usage{
countColors(path, color.range = "spherical", center, radius, lower,
  upper, bg.lower = rep(0.8, 3), bg.upper = rep(1, 3),
  target.color = c("magenta", "cyan", "yellow"), plotting = FALSE,
  save.indicator = FALSE, dpi = 72, return.indicator = FALSE)
}
\arguments{
\item{path}{Path to the image (JPEG or PNG).}

\item{color.range}{Type of range being specified. Must be either "spherical"
or "rectangular".}

\item{center}{A vector or n x 3 matrix of color centers (RGB triplets) around
which to search using spherical color range. RGB range 0-1 (not 0-255). See
details.}

\item{radius}{Values between 0 and 1 specifying the size of the area around
\code{center} to search. The same number of centers and radii must be
specified.}

\item{lower, upper}{RGB triplet(s) specifying the bounds of color space
to search. Must be the same length. See details.}

\item{bg.lower, bg.upper}{RGB triplets specifying the bounds of color space to
ignore as background, or \code{NULL} to use the entire image.}

\item{target.color}{If an indicator image is created, the color with which to
replace specified pixels. Can be either an RGB triplet or one of the
colors listed by \code{\link[grDevices]{colors}}.}

\item{plotting}{Logical. Should output be plotted in the plot window?}

\item{save.indicator}{Logical OR path for saving indicator image. If TRUE,
saves image to the same directory as the original image as
'originalimagename_masked.png'; if a path is provided, saves it to that
directory/name instead.}

\item{dpi}{Resolution (dots per image) for saving indicator image.}

\item{return.indicator}{Logical. Should an indicator image (RGB array with
targeted pixels changed to indicator color) be returned?}
}
\value{
A list with the following attributes:
\itemize{
  \item \code{pixel.idx}: Unique coordinates of pixels within color range(s).
  \item \code{pixel.fraction}: Proportion of the non-background image within
  color range(s), found by dividing the number of pixels in \code{pixel.idx}
  by the number of non-background pixels in the image.
  \item \code{indicator.img}: If \code{return.indicator = TRUE}, RGB array with
  color-swapped pixels.
}
}
\description{
Counts the pixels within a color range; ranges can be spherical (see
\code{\link{sphericalRange}}) or rectangular
(\code{\link{rectangularRange}}). If multiple ranges are specified, each one
is colored using a different indicator color.
}
\details{
More than one set of ranges can be specified for the color search
  space, but the same number of arguments must be provided in each case (so
  the number of pixels and centers must be the same if using a spherical
  range, and the number of upper and lower bounds must be the same if using a
  rectangular one).

For \code{center}, \code{upper}, and \code{lower}, which call for RGB
triplets, provide either a vector of RGB triplets in RGB order, i.e. c(R1,
G1, B1, R2, G2, B2, etc) or a 3-column matrix with one row per RGB triplet.
If a vector is provided, it is coerced to a 3-column matrix, and must
therefore be a multiple of 3.
}
\examples{

# Try out a few different radii for white pelicans
pelicans <- system.file("extdata", "pelicans.jpg", package = "countcolors")

white.ctr <- rep(0.9, 9)
white.radii <- c(0.5, 0.3, 0.1)

# Magenta = 50\% threshold, cyan = 30\% threshold, yellow = 10\% threshold
pelican.example <- countcolors::countColors(pelicans, center = white.ctr,
radius = white.radii, bg.lower = NULL, plotting = TRUE)

}
\seealso{
\code{\link{countColorsInDirectory}}
}
