% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sepindex.R
\docType{class}
\name{sepindex-class}
\alias{sepindex-class}
\alias{sepindex}
\alias{boxplot,sepindex-method}
\alias{sepindex-class}
\title{Class "sepindex"}
\usage{
sepindex(nt, ns, vario_st, globalSill)

\S4method{boxplot}{sepindex}(x, ...)
}
\arguments{
\item{nt}{integer, the number of temporal lags in \code{vario_st}}

\item{ns}{integer, the number of spatial lags in \code{vario_st}}

\item{vario_st}{spatio-temporal sample variogram, output from
\code{\link[gstat]{variogramST}}}

\item{globalSill}{numeric, the value of the sample variance}

\item{x}{object of class \code{sepindex}}

\item{...}{any arguments that will be passed to the panel plotting functions}
}
\description{
A class for the non-separability index (r) for different spatial
and temporal lags:
\deqn{r(h, u, \Theta)= \rho(h, u;\Theta)/ [\rho(h,0;\Theta)\rho(0,u;\Theta)]}
with \eqn{\rho(h, u;\Theta)>0}; \eqn{\rho(h,0;\Theta)>0} and \eqn{\rho(0,u;\Theta)>0}.
On the basis of this index, the type of non-separability of the covariance
function can be analyzed.
}
\section{Slots}{

\describe{
\item{\code{sep.index.ratio}}{the empirical non-separability index ratio}

\item{\code{cov.tm}}{the purely temporal sample covariance function}

\item{\code{cov.sp}}{the purely spatial sample covariance function}

\item{\code{cov.st}}{the spatio-temporal sample covariance function}
}}

\examples{
library(covatest)
data(rr_13)
data(vv_13)
#compute the globalSill
C00_13 <- var(rr_13[, ,"PM10"]@data[[1]], na.rm = TRUE)
nonsepind <- sepindex(nt = 16, ns = 4, vario_st = vv_13, globalSill = C00_13)

}
\references{
De Iaco, S., Posa, D., 2013, Positive and negative non-separability
for space-time covariance models. Journal of Statistical Planning and
Inference, \bold{143} 378--391.

Pebesma, E., 2004, Multivariable geostatistics in S: the gstat
package. Computers & Geosciences, \bold{30} 683--691.

Rodriguez, A., Diggle, P.J., 2010, A class of convolution-based
models for spatio-temporal processes with non-separable covariance structure.
Scandinavian Journal of Statistics, \bold{37(4)} 553--567.
}
\seealso{
\code{\link[gstat]{variogramST}}
}
