% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covastatM.R
\docType{class}
\name{covastatM-class}
\alias{covastatM-class}
\alias{covastatM}
\alias{show,covastatM-method}
\alias{covastatM-method}
\title{Class "covastatM"}
\usage{
covastatM(
  matdata,
  pardata1,
  pardata2,
  stpairs,
  typetest = "productSum",
  beta.data = NULL
)

\S4method{show}{covastatM}(object)
}
\arguments{
\item{matdata}{STFDF/STSDF or \code{data.frame}, which contains the
coordinates of the spatial points, the identification code of the spatial
points, the indentification code of the temporal points and the values of
the variable, typically output from \code{read.STdata}}

\item{pardata1}{integer, it represents the column in which the spatial ID is
stored (if the spatio-temporal data set is given as data.frame) or the number of
variables in the STFDF/STSDF (if the data are given as a STFDF/STSDF)}

\item{pardata2}{integer, it represents the column in which the values of the
variable are stored (if the spatio-temporal data set is given as data.frame) or
the slot in which the values of the variable of interest are stored
(if the data are given as a STFDF/STSDF). Note that for STFDF/STSDF the
argument is set, by default, equal to 1 if the number of variables is equal to 1}

\item{stpairs}{object of class \code{couples}, containing the spatial
points and the corresponding temporal lags to be analyzed}

\item{typetest}{character, set \code{typetest = "productSum"} for the test
on the product-sum class of models (default choice), \code{typetest = "intProduct"}
for the test on the integrated product class of models, \code{typetest = "gneiting"}
for the test on the Gneiting class of models}

\item{beta.data}{vector, this argument is required only for \code{typetest = "gneiting"},
otherwise it has to be set equal to NULL (default choice). It contains the
different values of the parameter beta, which can assume values in the range 0-1}

\item{object}{object of class \code{covastatM} for method \code{show}}
}
\description{
A class for the sample spatio-temporal covariances for the specified spatial
and temporal lags, given in \code{stpairs} (object of class \code{couple}),
for the test on the type of class of models.
Depending on the type of test, the empirical variance, the sample spatial
and temporal marginal covariances are also computed
}
\details{
{
\itemize{
\item If \code{typetest = "intProduct"} (test on the integrated product class
of models) \code{cova.h} and \code{cova.u} are not available
\item If \code{typetest = "gneiting"} (test on the Gneiting class of models),
\code{cova.h} is not available
\item A message appears on the user's console if the \code{G} vector
contains spatio-temporal negative covariances. The message returns the negative
value/values and it will help to identify the spatial and the temporal lags
involved
}
}
}
\section{Slots}{

\describe{
\item{\code{G}}{matrix, containing the spatio-temporal covariances for the specified
lags. For all tests, the sample variance and the sample spatial and temporal
marginal covariances are also computed and stored in \code{G}}

\item{\code{cova.h}}{matrix, containing the sample spatial marginal covariances
for the specified lags}

\item{\code{cova.u}}{matrix, containing the sample temporal marginal covariances
for the specified lags}

\item{\code{f.G}}{array, containing the computation of specific functions of the
elements of \code{G}, see references}

\item{\code{B}}{matrix, containing the computation of the derivatives of each element
of \code{f.G} with respect to each element of \code{G}}

\item{\code{A}}{contrast matrix}

\item{\code{beta.data}}{vector, containing the different values of the parameter beta,
available only for the test on the Gneiting class of model (\code{typetest = "gneiting"})}

\item{\code{typetest}}{character, contains the code of the test to be performed}
}}

\note{
{
\itemize{
\item A stop occurs if the number of spatial points fixed in \code{stpairs}
(object of class \code{couples}) is less than 2
\item A stop occurs if more than 75\% of consecutive data are missing in the time
series, since a large number of missing values do not guarantee the reliability
of the tests
}
}
}
\examples{
# --start define the STFDF rr_13-- #
library(sp)
library(spacetime)
library(gstat)
data(air)
ls()
if (!exists("rural")) rural = STFDF(stations, dates, data.frame(PM10 =
as.vector(air)))
rr = rural[,"2005::2010"]
unsel = which(apply(as(rr, "xts"), 2, function(x) all(is.na(x))))
r5to10 = rr[-unsel,]
rr_13 <- r5to10[c("DEHE046","DESN049","DETH026","DENW063","DETH061","DEBY047",
"DENW065","DEUB029","DENW068","DENI019","DEHE051","DERP016","DENI051"),
"2005::2006"]
# --end define the STFDF rr_13-- #

sel.staz.mod <- c("DERP016", "DENW065", "DENW063", "DEHE046", "DEUB029",
"DETH061", "DENW068", "DETH026", "DENI051")

sp.couples.in.mod <- matrix(data = c("DERP016", "DENW065", "DENW063", "DEHE046",
                                    "DEUB029", "DETH061", "DEHE046", "DENW063",
                                    "DERP016", "DENW068", "DETH026", "DENI051",
                                    "DEUB029", "DETH061", "DENI051", "DETH061",
                                    "DERP016", "DEUB029"),
                           ncol = 2, byrow = TRUE)

t.couples.in.mod <- c(1, 2, 3)

couples.mod <- couples(sel.staz = sel.staz.mod, sp.couples.in =
                        sp.couples.in.mod, t.couples.in = t.couples.in.mod,
                      typetest = "productSum", typecode = character())

zero.index <- matrix(data=c(3, 7, 6, 7, 9, 7), ncol=2, byrow = TRUE)

couples.mod <- setzero(x = couples.mod, zero = FALSE, index = zero.index, value = 0)

covast.ps <- covastatM(matdata = rr_13, pardata1 = 1, pardata2 = 1,
                       stpairs = couples.mod, typetest = "productSum", beta.data = NULL)

### method for covastat
#1. show
covast.ps

}
\references{
Cappello, C., De Iaco, S., Posa, D., 2018, Testing the type of
non-separability and some classes of space-time covariance function models.
Stochastic Environmental Research and Risk Assessment,
\bold{32} 17--35

Cappello, C., De Iaco, S., Posa, D., 2020, {covatest}: An {R} Package for
Selecting a Class of Space-Time Covariance Functions.
Journal of Statistical Software, \bold{94(1)} 1--42.

De Iaco, S., Palma, M., Posa, D., 2016. A general procedure for selecting a
class of fully symmetric space-time covariance functions.
Environmentrics, \bold{27(4)} 212--224.

Li, B., Genton, M.G., Sherman, M., 2007, A nonparametric assessment
of properties of spacetime covariance functions.
Journal of the American Statistical Association, \bold{102} 736--744.
}
\seealso{
\linkS4class{couples}

\code{\link{read.STdata}}
}
