% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor.R
\name{covidcast_cor}
\alias{covidcast_cor}
\title{Compute correlations between two \code{covidcast_signal} data frames}
\usage{
covidcast_cor(
  x,
  y,
  dt_x = 0,
  dt_y = 0,
  by = c("geo_value", "time_value"),
  use = "na.or.complete",
  method = c("pearson", "kendall", "spearman")
)
}
\arguments{
\item{x, y}{The \code{covidcast_signal} data frames to correlate.}

\item{dt_x, dt_y}{Time shifts to consider for \code{x} and \code{y}, respectively,
before computing correlations. Negative shifts translate into in a lag
value and positive shifts into a lead value; for example, if \code{dt = -1},
then the new value on June 2 is the original value on June 1; if \code{dt = 1},
then the new value on June 2 is the original value on June 3; if \code{dt = 0},
then the values are left as is. Default is 0 for both \code{dt_x} and \code{dt_y}.}

\item{by}{If "geo_value", then correlations are computed for each geo
location, over all time. Each correlation is measured between two time
series at the same location. If "time_value", then correlations are
computed for each time, over all geo locations. Each correlation is
measured between all locations at one time. Default is "geo_value".}

\item{use, method}{Arguments to pass to \code{cor()}, with "na.or.complete" the
default for \code{use} (different than \code{cor()}) and "pearson" the default for
\code{method} (same as \code{cor()}).}
}
\value{
A data frame with first column \code{geo_value} or \code{time_value} (depending
on \code{by}), and second column \code{value}, which gives the correlation.
}
\description{
Computes correlations between two \code{covidcast_signal} data frames, allowing
for slicing by geo location, or by time. (Only the latest issue from each
data frame is used for correlations.) See the correlations vignette
for examples: \code{vignette("correlation-utils", package = "covidcast")}
}
