% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covr.R
\name{package_coverage}
\alias{package_coverage}
\title{Calculate test coverage for a package}
\usage{
package_coverage(path = ".", type = c("tests", "vignettes", "examples",
  "all", "none"), combine_types = TRUE, relative_path = TRUE,
  quiet = TRUE, clean = TRUE, line_exclusions = NULL,
  function_exclusions = NULL, code = character(), ..., exclusions)
}
\arguments{
\item{path}{file path to the package}

\item{type}{run the package \sQuote{test}, \sQuote{vignette},
\sQuote{example}, \sQuote{all}, or \sQuote{none}. The default is
\sQuote{test}.}

\item{combine_types}{If \code{TRUE} (the default) the coverage for all types
is simply summed into one coverage object. If \code{FALSE} separate objects
are used for each type of coverage.}

\item{relative_path}{whether to output the paths as relative or absolute
paths.}

\item{quiet}{whether to load and compile the package quietly}

\item{clean}{whether to clean temporary output files after running.}

\item{line_exclusions}{a named list of files with the lines to exclude from
each file.}

\item{function_exclusions}{a vector of regular expressions matching function
names to exclude. Example \code{print\\.} to match print methods.}

\item{code}{Additional test code to run.}

\item{...}{Additional arguments passed to \code{\link[tools]{testInstalledPackage}}}

\item{exclusions}{\sQuote{Deprecated}, please use \sQuote{line_exclusions} instead.}
}
\description{
Calculate test coverage for a package
}
\seealso{
exclusions
}

