% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/covsep.R
\name{marginal_covariances}
\alias{marginal_covariances}
\title{estimates marginal covariances (e.g. row and column covariances) of bi-dimensional sample}
\usage{
marginal_covariances(Data)
}
\arguments{
\item{Data}{a (non-empty) \code{N x d1 x d2} array of data values. The first
direction indices the \eqn{N} observations, each consisting of a \code{d1 x d2}
discretization of the surface, so that \code{Data[i,,]} corresponds to the
i-th observed surface.}
}
\value{
A list containing the row covariance (\code{C1}) and column covariance (\code{C2})
}
\description{
estimates marginal covariances (e.g. row and column covariances) of bi-dimensional sample
}
\examples{
Data  <-  rmtnorm(30, C1, C2)
marginal.cov  <- marginal_covariances(Data)
}

