% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcarma.R
\name{rcarma}
\alias{rcarma}
\title{Simulate censored ARMA time series}
\usage{
rcarma(n = 100, ar = 0.6, ma = 0.4, mu = 0, siga = 1,
  rates = c(NA, 0.2), Mrate = 0)
}
\arguments{
\item{n}{length of series, default 100.}

\item{ar}{ar coefficients}

\item{ma}{ma coefficients}

\item{mu}{mean}

\item{siga}{standard deviation of innovations}

\item{rates}{either a vector of length 2 or a matrix with n rows and 2 columns.
In the vector case, the first element indicates the left-censor rate and
the second element indicates the right-censor rate. Set to NA if there
is no censoring. Interval censored data corresponds to setting both a
left-censor rate and right-censor rate. The default setting indicates
a right-censor rate 0.2 with no left censoring. The vector case handles
single censoring and the matrix case is for multiple censor points.
In this case each column indicates the corresponding censoring for
each observation.}

\item{Mrate}{fraction of missing values. Default is 0}
}
\value{
an object of class 'censored' which is a list with three elements.
First element, 'y', is the censored time series. Second element, 'iy',
indicates for each observed valued "o", "L", "R", NA according to
whether the value is fully observed, left-censored, right-censored,
or missing. Third element, 'censorPts', is a matrix with 2 columns
indicating the censor point or NA if no censoring is applicable.
Note that censorPts does not indicate if the observation was actually
censored since this depends on the unknown latent variable.
 An observation is censored if and only if the corresponding entry in
iy is either "L" or "R".  See example below
}
\description{
Randomly Generate Censored ARMA
}
\examples{
#Default example
library(cpcens)
ans<-rcarma()
#example (right censoring)
ans = rcarma (n=100 , ar=0.2, ma = 0.6, mu=0 , siga=1, rates=c(NA,0.7), Mrate=0 )
#example (left censoring)
ans = rcarma (n=100 , ar=0.7, ma = 0.3,  mu=0 , siga=1, rates=c(0.3,NA), Mrate=0 )
#example (interval censoring)
ans = rcarma (n=100 , ar=0.7, ma = 0.2, mu=0 , siga=1, rates=c(0.25,0.25), Mrate=0 )
}
