% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dctp.R, R/pctp.R, R/qctp.R, R/rctp.R
\name{cbp}
\alias{cbp}
\alias{dcbp}
\alias{pcbp}
\alias{qcbp}
\alias{rcbp}
\title{The Complex Biparametric Pearson (CBP) Distribution}
\usage{
dcbp(x, b, gamma)

pcbp(q, b, gamma, lower.tail = TRUE)

qcbp(p, b, gamma, lower.tail = TRUE)

rcbp(n, b, gamma)

pcbp(q, b, gamma, lower.tail = TRUE)

qcbp(p, b, gamma, lower.tail = TRUE)

rcbp(n, b, gamma)
}
\arguments{
\item{x}{vector of (non-negative integer) quantiles.}

\item{b}{parameter b (real)}

\item{gamma}{parameter gamma (positive)}

\item{q}{vector of quantiles.}

\item{lower.tail}{if TRUE (default), probabilities are \eqn{P(X<=x)}, otherwise, \eqn{P(X>x)}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}
}
\value{
\code{dcbp} gives the pmf, \code{pcbp} gives the distribution function, \code{qcbp} gives the quantile function and \code{rcbp} generates random values.
}
\description{
Probability mass function, distribution function, quantile function and random generation for the Complex Biparametric Pearson (CBP) distribution with parameters \eqn{b} and \eqn{\gamma}.
}
\details{
The CBP distribution with parameters \eqn{b} and \eqn{\gamma} has pmf
\deqn{f(x|b,\gamma) = C \Gamma(ib+x) \Gamma(-ib+x) / (\Gamma(\gamma+x) x!), x=0,1,2,...} 
where \eqn{i} is the imaginary unit, \eqn{\Gamma(·)} the gamma function and 
\deqn{C = \Gamma(\gamma-ib) \Gamma(\gamma+ib) / (\Gamma(\gamma) \Gamma(ib) \Gamma(-ib))}
the normalizing constant.

The CBP is a particular case of the CTP when \eqn{a=0}.

The mean and the variance of the CBP distribution are
\eqn{E(X)=\mu=b^2/(\gamma-1)} and \eqn{Var(X)=\mu(\mu+\gamma-1)/(\gamma-2)}
so \eqn{\gamma > 2}.

It is always overdispersed.
}
\examples{
# Examples for the function dcbp
dcbp(3,2,5)
dcbp(c(3,4),2,5)

# Examples for the function pcbp
pcbp(3,2,3)
pcbp(c(3,4),2,3)
# Examples for the function qcbp
qcbp(0.5,2,3)
qcbp(c(.8,.9),2,3)
# Examples for the function rcbp(4,1,3)
}
\references{
\insertRef{RCS2003}{cpd}
}
\seealso{
Probability mass function, distribution function, quantile function and random generation for the CTP distribution: \code{\link{dctp}}, \code{\link{pctp}}, \code{\link{qctp}} and \code{\link{rctp}}.
Functions for maximum-likelihood fitting of the CBP distribution: \code{\link{fitcbp}}.
}
