% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitctp.R
\name{fitcbp}
\alias{fitcbp}
\title{Maximum-likelihood fitting of the Complex Biparametric Pearson (CBP) distribution}
\usage{
fitcbp(x, bstart = 1, gammastart = 1.1, method = "L-BFGS-B", 
       moments = FALSE, hessian = TRUE, control = list(), ...)
}
\arguments{
\item{x}{A numeric vector of length at least one containing only finite values.}

\item{bstart}{An starting value for the parameter \eqn{b}; by default 1.}

\item{gammastart}{An starting value for the parameter \eqn{\gamma}; by default 1.1.}

\item{method}{The method to be used in fitting the model. The default method is "L-BFGS-B" (optim).}

\item{moments}{If \code{TRUE} the estimates of \eqn{b} and \eqn{\gamma} by the method of moments are used as starting values (if it is posible). By default this argument is \code{FALSE}.}

\item{hessian}{If \code{TRUE} the hessian of the objective function at the minimum is returned.}

\item{control}{A list of parameters for controlling the fitting process.}

\item{...}{Additional parameters.}
}
\value{
An object of class "fitcbp" is a list containing the following components:

\itemize{
\item \code{n}, the number of observations,
\item \code{initialValues}, a vector with the starting values used,
\item \code{coefficients}, the parameter ML estimates of the CTP distribution,
\item \code{se}, a vector of the standard error estimates,
\item \code{hessian}, a symmetric matrix giving an estimate of the Hessian at the solution found in the optimization of the log-likelihood function,
\item \code{cov}, an estimate of the covariance matrix of the model coefficients,
\item \code{corr}, an estimate of the correlation matrix of the model estimates,
\item \code{loglik}, the maximized log-likelihood,
\item \code{aic}, Akaike Information Criterion, minus twice the maximized log-likelihood plus twice the number of parameters,
\item \code{bic}, Bayesian Information Criterion, minus twice the maximized log-likelihood plus twice the number of parameters,
\item \code{code}, a code that indicates successful convergence of the fitter function used (see nlm and optim helps),
\item \code{converged},  logical value that indicates if the optimization algorithms succesfull,
\item \code{method}, the name of the fitter function used.
}
}
\description{
Maximum-likelihood fitting of the Complex Biparametric Pearson (CBP) distribution with parameters \eqn{b} and \eqn{\gamma}.
}
\examples{
set.seed(123)
x <- rcbp(500, 1.75, 3.5)
fitcbp(x)
fitcbp(x, bstart = 1.1, gammastart = 3)
fitcbp(x, moments = TRUE)
}
\references{
\insertRef{RCS2003}{cpd}
}
\seealso{
Maximum-likelihood fitting for the CTP distribution: \code{\link{fitctp}}.
}
