% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisq.test2.R
\name{chisq.test2}
\alias{chisq.test2}
\title{Pearson's Chi-squared Test for Count Data}
\usage{
chisq.test2(obs, p.esp, npar = NULL, grouping = FALSE)
}
\arguments{
\item{obs}{a numeric vector with the counts}

\item{p.esp}{a numeric vector with the expected probabilities of the same length of \code{obs}. They must sum 1.}

\item{npar}{an integer specifying the number of parameters of the model. By default \code{npar} is \code{NULL}, so the degrees of freedom of
the chi-squared statistics are the number of classes minus 1.}

\item{grouping}{a logical indicating whether to group in classes with expected frequency greater than or equal to 5. By default \code{grouping} is \code{FALSE}.}
}
\value{
A list with class \code{"htest"} containing the following components:
\itemize{
\item \code{statistic}: the value of the chi-squared test statistic.
\item \code{df}: the degrees of freedom of the approximate chi-squared distribution.
\item \code{p.value}: the p-value for the test.
\item \code{observed}: the observed counts.
\item \code{observed.grouped}: the observed counts grouped in classes with expected frequency greather or equal to 5.
\item \code{expected}: the expected counts under the null hypothesis.
\item \code{expected.grouped}: the expected counts under the null hypothesis grouped in classes with expected frequency greather or equal to 5.
\item \code{residuals}: the Pearson residuals computed as \code{(observed - expected) / sqrt(expected)}.
}
}
\description{
\code{chisq.test2} performs Pearson chi-squared goodness-of-fit test for count data
}
\examples{
set.seed(123)
x <- rctp(500, -1.5, 1, 2)
table(x)
obs <- c(172, 264, 57, 6, 0, 1)
fit <- fitctp(x)
p.esp <- c(dctp(0:(length(obs)-1),fit$coefficients[1],fit$coefficients[2],
           fit$coefficients[3])[1:(length(obs)-1)],1-sum(dctp(0:(length(obs)-1),
           fit$coefficients[1],fit$coefficients[2],fit$coefficients[3])[1:(length(obs)-1)]))
chisq.test2(obs, p.esp)
chisq.test2(obs, p.esp, grouping = TRUE)
chisq.test2(obs, npar= 3, p.esp)
}
