% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpop.R
\name{simchangeslope}
\alias{simchangeslope}
\title{A function for generating simulated data}
\usage{
simchangeslope(x, changepoints, change.slope, sd = 1)
}
\arguments{
\item{x}{A numeric vector containing the locations of the data.}

\item{changepoints}{A numeric vector of changepoint locations.}

\item{change.slope}{A numeric vector indicating the change in slope at each changepoint. The initial slope is assumed to be 0.}

\item{sd}{The residual standard deviation. Can be a single numerical value or a vector of values for the case of varying residual standard deviation. Default value is 1.}
}
\value{
A vector of simulated y values.
}
\description{
Generates simulated data for use with \code{\link{cpop}}.
}
\examples{
library(cpop)
library(pacman)
p_load(ggplot2)

# simulate changepoints with constant sd
set.seed(1)
changepoints <- c(0,25,50,100)
change.slope <- c(0.2,-0.3,0.2,-0.1)
x <- 1:200
sd <- 0.2
y <- simchangeslope(x,changepoints,change.slope,sd)
df <- data.frame("x"=x,"y"=y)
p <- ggplot(data=df,aes(x=x,y=y))
p <- p + geom_point()
p <- p + geom_vline(xintercept=changepoints,
                    color="red",
                    linetype="dashed")
print(p)

# simulate changepoints with varying sd
sd <- 0.2 + x/200
y <- simchangeslope(x,changepoints,change.slope,sd)
df$y <- y
p <- ggplot(data=df,aes(x=x,y=y))
p <- p + geom_point()
p <- p + geom_vline(xintercept=changepoints,
                    color="red",
                    linetype="dashed")
print(p)

}
