% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplify.R
\name{cpp_simplify}
\alias{cpp_simplify}
\title{Reduce the number of edges by removing non-intersection nodes, duplicated edges and isolated loops in the graph.}
\usage{
cpp_simplify(Graph, keep = NULL, new_edges = FALSE, rm_loop = TRUE,
  iterate = FALSE, silent = TRUE)
}
\arguments{
\item{Graph}{An object generated by cppRouting::makegraph() function.}

\item{keep}{Character or integer vector. Nodes of interest that will not be removed. Default to NULL}

\item{new_edges}{Logical. If TRUE, new edges created by removing nodes are returned as character vectors of the following form : \emph{junction node - removed node(s) - junction node}. Default to FALSE}

\item{rm_loop}{Logical. if TRUE, isolated loops as removed. Default to TRUE}

\item{iterate}{Logical. If TRUE, process is repeated until only intersection nodes remain in the graph. Default to FALSE}

\item{silent}{Logical. If TRUE and iterate set to TRUE, number of iteration and number of removed nodes are printed to the console.}
}
\value{
List of length two containing the simplified cppRouting graph and new edges
}
\description{
Reduce the number of edges by removing non-intersection nodes, duplicated edges and isolated loops in the graph.
}
\details{
To understand why process can be iterated, see the package description : https://github.com/vlarmet/cppRouting  

The first iteration usually eliminates the majority of non-intersection nodes and is therefore faster.
Created edges at n-th iteration will be stored at n-th list of \emph{new_edges} list.
}
\examples{
#Simple directed graph
edges<-data.frame(from=c(1,2,3,4,5,6,7,8),
                  to=c(0,1,2,3,6,7,8,5),
                  dist=c(1,1,1,1,1,1,1,1))
                  
#Plot
if(requireNamespace("igraph",quietly = TRUE)){
igr<-igraph::graph_from_data_frame(edges)
plot(igr)
}

#Construct cppRouting graph
graph<-makegraph(edges,directed=TRUE)
                                    
#Simplify the graph, removing loop
simp<-cpp_simplify(graph, rm_loop=TRUE)

#Convert cppRouting graph to data frame
simp<-to_df(simp$graph)

#Plot
if(requireNamespace("igraph",quietly = TRUE)){
igr<-igraph::graph_from_data_frame(simp)
plot(igr)
}

#Simplify the graph, keeping node 2 and keeping loop
simp<-cpp_simplify(graph,keep=2 ,rm_loop=FALSE) 

#Convert cppRouting graph to data frame
simp<-to_df(simp$graph)

#Plot
if(requireNamespace("igraph",quietly = TRUE)){
igr<-igraph::graph_from_data_frame(simp)
plot(igr)
}

}
