% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_multi_paths.R
\name{get_multi_paths}
\alias{get_multi_paths}
\title{Compute all shortest paths between origin and destination nodes.}
\usage{
get_multi_paths(Graph, from, to, keep = NULL, long = FALSE)
}
\arguments{
\item{Graph}{An object generated by makegraph() or cpp_simplify() function.}

\item{from}{A vector of one or more vertices from which shortest paths are calculated (origin).}

\item{to}{A vector of one or more vertices (destination).}

\item{keep}{numeric or character. Vertices of interest that will be returned.}

\item{long}{logical. If TRUE, a long data.frame is returned instead of a list.}
}
\value{
List or a data.frame containing shortest paths.
}
\description{
Compute all shortest paths between origin and destination nodes.
}
\details{
get_multi_paths() recursively perform Dijkstra algorithm for each 'from' nodes.
}
\note{
Be aware that if 'from' and 'to' have consequent size, output will require much memory space.
}
\examples{
#Data describing edges of the graph
edges<-data.frame(from_vertex=c(0,0,1,1,2,2,3,4,4), 
                  to_vertex=c(1,3,2,4,4,5,1,3,5), 
                  cost=c(9,2,11,3,5,12,4,1,6))
                  
#Get all nodes
nodes<-unique(c(edges$from_vertex,edges$to_vertex))
                  
#Construct directed and undirected graph 
directed_graph<-makegraph(edges,directed=TRUE)
non_directed<-makegraph(edges,directed=FALSE)

#Get all shortest paths between all nodes in the two graphs
dir_paths<-get_multi_paths(Graph=directed_graph, from=nodes, to=nodes)
non_dir_paths<-get_multi_paths(Graph=non_directed, from=nodes, to=nodes)
print(dir_paths)
print(non_dir_paths)
}
