% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expfns.R
\name{exp_memsim}
\alias{exp_memsim}
\title{Memoryless simulation for the exponential change-point hazard distribution}
\usage{
exp_memsim(theta, n, endtime, tau = NA)
}
\arguments{
\item{theta}{Scale parameter \eqn{\theta}}

\item{n}{Sample size}

\item{endtime}{Maximum study time, point at which all participants
are censored}

\item{tau}{Change-point(s) \eqn{\tau}}
}
\value{
Dataset with n participants including a survival time
and censoring indicator (0 = censored, 1 = event).
}
\description{
\code{exp_memsim} simulates time-to-event data from the exponential change-point
hazard distribution by implementing the memoryless method.
}
\details{
This function simulates time-to-event data between \eqn{K} change-points from
independent exponential distributions using the inverse CDF implemented
in \code{exp_icdf}. This method applies Type I right censoring at the endtime
specified by the user.
}
\examples{
nochangepoint <- exp_memsim(theta = 0.05, n = 10, endtime = 20)
onechangepoint <- exp_memsim(theta = c(0.05, 0.01), n = 10,
  endtime = 20, tau = 10)
twochangepoints <- exp_memsim(theta = c(0.05, 0.01, 0.05),
  n = 10, endtime = 20, tau = c(8, 12))

}
