% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_selection.R
\name{psi_iv_filter}
\alias{psi_iv_filter}
\title{Variable reduction based on Information Value & Population Stability Index filter}
\usage{
psi_iv_filter(dat, dat_test = NULL, target, x_list = NULL,
  breaks_list = NULL, pos_flag = NULL, ex_cols = NULL,
  occur_time = NULL, oot_pct = 0.7, psi_i = 0.1, iv_i = 0.01,
  cos_i = 0.9, vars_name = FALSE, note = TRUE, parallel = FALSE,
  save_data = FALSE, file_name = NULL, dir_path = tempdir(), ...)
}
\arguments{
\item{dat}{A data.frame with independent variables and target variable.}

\item{dat_test}{A data.frame of test data. Default is NULL.}

\item{target}{The name of target variable.}

\item{x_list}{Names of independent variables.}

\item{breaks_list}{A table containing a list of splitting points for each independent variable. Default is NULL.}

\item{pos_flag}{The value of positive class of target variable, default: "1".}

\item{ex_cols}{A list of excluded variables. Regular expressions can also be used to match variable names. Default is NULL.}

\item{occur_time}{The name of the variable that represents the time at which each observation takes place.}

\item{oot_pct}{Percentage of observations retained for overtime test (especially to calculate PSI). Defualt is 0.7}

\item{psi_i}{The maximum threshold of PSI.  0 <= psi_i <=1; 0.05 to 0.2 usually work. Default: 0.1}

\item{iv_i}{The minimum threshold of IV. 0 < iv_i ; 0.01 to 0.1 usually work. Default: 0.01}

\item{cos_i}{cos_similarity of posive rate of train and test. 0.7 to 0.9 usually work.Default: 0.5.}

\item{vars_name}{Logical, output a list of filtered variables or table with detailed IV and PSI value of each variable. Default is FALSE.}

\item{note}{Logical, outputs info. Default is TRUE.}

\item{parallel}{Logical, parallel computing. Default is FALSE.}

\item{save_data}{Logical, save results in locally specified folder. Default is FALSE.}

\item{file_name}{The name for periodically saved results files.  Default is "Featrue_importance_IV_PSI".}

\item{dir_path}{The path for periodically saved results files.  Default is tempdir().}

\item{...}{Other parameters.}
}
\value{
A list with the following elements:
\itemize{
  \item \code{Feature} Selected variables.
  \item \code{IV} IV of variables.
  \item \code{PSI} PSI of variables.
  \item \code{COS} cos_similarity of posive rate of train and test.
}
}
\description{
\code{psi_iv_filter}  is for selecting important and stable features using IV & PSI.
}
\examples{
psi_iv_filter(dat= UCICreditCard[1:1000,c(2,4,8:9,26)],
             target = "default.payment.next.month",
             occur_time = "apply_date",
             parallel = FALSE)
}
\seealso{
\code{\link{xgb_filter}}, \code{\link{gbm_filter}}, \code{\link{feature_select_wrapper}}
}
