% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{convert2percentages}
\alias{convert2percentages}
\title{Convert abundance data into percentage data.}
\usage{
convert2percentages(df, col2convert = 2:ncol(df))
}
\arguments{
\item{df}{The dataframe containing the data to convert.}

\item{col2convert}{A vector of the columns to convert. Default is all the
columns but the first, which contains an age, a depth or a sampleID.}
}
\value{
A vector of unique taxonIDs.
}
\description{
Convert abundance data into percentage data.
}
\examples{
df <- data.frame(matrix(1:25, ncol = 5))
colnames(df) <- paste(rep("col", 5), 1:5, sep = "")
convert2percentages(df)
convert2percentages(df, col2convert = 3:5)
}
