% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crest.R
\name{crest}
\alias{crest}
\title{A wrapper for all the crest functions.}
\usage{
crest(
  df,
  climate,
  pse = NA,
  taxaType = 0,
  distributions = NA,
  site_info = rep(NA, length(climate)),
  site_name = NA,
  xmn = NA,
  xmx = NA,
  ymn = NA,
  ymx = NA,
  continents = NA,
  countries = NA,
  realms = NA,
  biomes = NA,
  ecoregions = NA,
  minGridCells = 20,
  selectedTaxa = NA,
  bin_width = rep(1, length(x$parameters$climate)),
  shape = rep("normal", length(x$parameters$climate)),
  npoints = 500,
  ai.sqrt = FALSE,
  geoWeighting = TRUE,
  climateSpaceWeighting = TRUE,
  presenceThreshold = 0,
  taxWeight = "normalisation",
  uncertainties = c(0.5, 0.95),
  leave_one_out = FALSE,
  verbose = TRUE,
  dbname = "gbif4crest_02"
)
}
\arguments{
\item{df}{A data frame containing the data to reconstruct (counts,
percentages or presence/absence data).}

\item{climate}{A vector of the climate variables to extract. See
\code{\link{accClimateVariables}} for the list of accepted values.}

\item{pse}{A pollen-Species equivalency table. See \code{\link{createPSE}} for
details.}

\item{taxaType}{A numerical index (between 1 and 6) to define the type of
palaeoproxy used: 1 for plants, 2 for beetles, 3 for chironomids,
4 for foraminifers, 5 for diatoms and 6 for rodents. The example
dataset uses taxaType=0 (pseudo-data). Default is 1.}

\item{distributions}{A dataframe containing the presence records of the
studied proxies and their associated climate values.}

\item{site_info}{A vector containing the coordinates of the study site.
Default \code{c(NA, NA)}.}

\item{site_name}{The name of the dataset (default \code{NA}).}

\item{xmn, xmx, ymn, ymx}{The coordinates defining the study area.}

\item{continents}{A vector of the continent names defining the study area.}

\item{countries}{A vector of the country names defining the study area.}

\item{realms}{A vector of the studied botanical realms defining the study area.}

\item{biomes}{A vector of the studied botanical biomes defining the study area.}

\item{ecoregions}{A vector of the studied botanical ecoregions defining the
study area.}

\item{minGridCells}{The minimum number of unique presence data necessary to
estimate a species' climate response. Default is 20.}

\item{selectedTaxa}{A data frame assigns which taxa should be used for each
variable (1 if the taxon should be used, 0 otherwise). The colnames
should be the climate variables' names and the rownames the taxa
names. Default is 1 for all taxa and all variables.}

\item{bin_width}{The width of the bins used to correct for unbalanced climate
state. Use values that split the studied climate gradient in
15-25 classes (e.g. 2°C for temperature variables). Default is 1.}

\item{shape}{The imposed shape of the species \code{pdfs}. We recommend using
'normal' for temperature variables and 'lognormal' for the
variables that can only take positive values, such as
precipitation or aridity. Default is 'normal' for all.}

\item{npoints}{The number of points to be used to fit the \code{pdfs}. Default 200.}

\item{ai.sqrt}{A boolean to indicate whether ai values should be square-root
transformed (default \code{FALSE}).}

\item{geoWeighting}{A boolean to indicate if the species should be weighting
by the square root of their extension when estimating a genus/family
level taxon-climate relationships.}

\item{climateSpaceWeighting}{A boolean to indicate if the species \code{pdfs}
should be corrected for the modern distribution of the climate space
(default \code{TRUE}).}

\item{presenceThreshold}{All values above that threshold will be used in the
reconstruction (e.g. if set at 1, all percentages below 1 will be set
to 0 and the associated presences discarded). Default is 0.}

\item{taxWeight}{One value among the following: 'originalData',
'presence/absence', 'percentages' or 'normalisation' (default).}

\item{uncertainties}{A (vector of) threshold value(s) indicating the error
bars that should be calculated (default both 50 and 95\% ranges).}

\item{leave_one_out}{A boolean to indicate whether the leave one out (loo)
reconstructions should be computed (default \code{FALSE}).}

\item{verbose}{A boolean to print non-essential comments on the terminal
(default \code{TRUE}).}

\item{dbname}{The name of the database. Default is \code{'gbif4crest_02'}.}
}
\value{
A \code{\link{crestObj}} containing the reconstructions.
}
\description{
Runs all the different steps of a CREST reconstruction in one function.
}
\examples{
\dontrun{
  data(crest_ex)
  data(crest_ex_pse)
  data(crest_ex_selection)
  reconstr <- crest(
    df = crest_ex, pse = crest_ex_pse, taxaType = 0,
    site_info = c(7.5, 7.5), site_name = 'crest_example',
    climate = c("bio1", "bio12"), bin_width = c(2, 50),
    shape = c("normal", "lognormal"),
    selectedTaxa = crest_ex_selection, dbname = "crest_example",
    leave_one_out = TRUE,
    verbose = FALSE
  )
  plot(reconstr)
  plot_loo(reconstr)
}

}
