% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.utils.R
\name{plot_map_eqearth}
\alias{plot_map_eqearth}
\title{Plots raster data in equal earth projection.}
\usage{
plot_map_eqearth(
  dat,
  ext = raster::extent(dat),
  zlim = range(raster::values(dat), na.rm = TRUE),
  col = viridis::viridis(20),
  brks.pos = c(0, 1),
  brks.lab = brks.pos,
  npoints = 15,
  nlines = 9,
  title = "",
  colour_scale = TRUE,
  top_layer = NA,
  top_layer.col = "ghostwhite",
  site_xy = NA,
  dim = NA
)
}
\arguments{
\item{dat}{The raster data to plot.}

\item{ext}{The extent to use to plot the data. (default is extent of dat)}

\item{zlim}{The range of the values to plot. (default is estimated from dat)}

\item{col}{The color gradient to use. (default is viridis)}

\item{brks.pos}{The position where to draw tick marks on the legend}

\item{brks.lab}{The labels to add where the tickmarks are draw (default is
tickmarks position)}

\item{npoints}{The number of points used to draw the polygons and lines along
each dimension. (default is 15 for a smooth result)}

\item{nlines}{The number of coordinate lines to add in the background
(default is 9)}

\item{title}{A description title (default is empty).}

\item{colour_scale}{A boolean to add the colour scale to the plot (default
\code{TRUE}).}

\item{top_layer}{A raster to overlay on top of the map (e.g. a distribution).}

\item{top_layer.col}{A colour for plotting top_layer (default 'ghostwhite').}

\item{site_xy}{Coordinates of a location to add to the plot.}

\item{dim}{The dimension of the plotting window in inches (default dev.size()).}
}
\value{
The set of coordinates ext projected in equal earth.
}
\description{
Plots raster data in equal earth projection.
}
