#' @importFrom magrittr %>%
#' @importFrom dplyr pull
#' @importFrom readr read_csv
#' @importFrom tidyr separate pivot_wider
#' @importFrom utils download.file read.csv unzip
#' @importFrom tibble tibble as_tibble
#'

#' @export
magrittr::`%>%`


#' Cricket Data from international and other major cricket matches.
#'
#' Data is provided by ESPNCricinfo and Cricsheet.
#' This package provides some functions to download the data
#' into tibbles ready for analysis.
#' Please respect the terms of use for each website:
#' \href{https://www.espncricinfo.com/ci/content/site/company/terms_use.html}{ESPNCricinfo},
#' \href{https://cricsheet.org/register/}{Cricsheet}.
#'
#' \tabular{ll}{Package: \tab cricketdata\cr Type: \tab Package\cr License: \tab
#' GPL3\cr LazyLoad: \tab yes\cr }
#'
#' @docType package
#' @name cricketdata
#' @keywords package
NULL
#"_PACKAGE"
