% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/compareCrimes.R
\name{expAbsDiff.circ}
\alias{expAbsDiff.circ}
\title{Expected absolute difference of two circular uniform RVs}
\usage{
expAbsDiff.circ(X, Y, mod = 24, n = 2000, method = "convolution")
}
\arguments{
\item{X}{c(min,min+length). X[1] must be >= 0 and X[2] >= X[1]. It is possible
 that X[2] can be > mod. I.e., do not do \code{X \%\% mod}}

\item{Y}{c(min,min+length). Same conditions from X applies.}

\item{mod}{the period of time. E.g., mod=24 for time of day (in hours),
 mod=7 for day of week (in days)}

\item{n}{number of bins for discretization of continuous time domain.}

\item{method}{use convolution or monte carlo integration (\code{montecarlo})}
}
\value{
the expected absolute difference
}
\description{
Estimates the expected circular temporal distance between crimes using discrete
  FFT or numerical integration
}
\keyword{internal}

