% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{matchTolerance}
\alias{matchTolerance}
\alias{\%~\%}
\title{Helper function for value matching with tolerance}
\usage{
matchTolerance(x, table)

x \%~\% table
}
\arguments{
\item{x}{the values to be matched}

\item{table}{the values to be matched against}
}
\value{
A vector of the same length as \code{x}
}
\description{
This is a modified version of \code{match} that supports tolerance.
}
\section{Functions}{
\itemize{
\item \code{\%~\%}: Helper function for checking inclusion in a table with tolerance
}}

\examples{
myDose <- c(rep(0.030, 6), rep(0.050, 3), rep(0.075, 4), rep(0.1, 9), rep(0.15, 7))
doseGrid <- seq(from = .025, to = .15, by = .005)

myDose \%in\% doseGrid
matchTolerance(myDose, doseGrid)
myDose \%~\% doseGrid

matchTolerance(c(myDose, 500), doseGrid)
c(myDose, 500) \%~\% doseGrid
}
\keyword{programming}
