% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-methods.R
\docType{methods}
\name{biomLevel}
\alias{biomLevel}
\alias{biomLevel,numeric,DualEndpoint,Samples-method}
\title{Compute the biomarker level for a given dose, given model and samples}
\usage{
biomLevel(dose, model, samples, ...)

\S4method{biomLevel}{numeric,DualEndpoint,Samples}(dose, model, samples,
  xLevel, ...)
}
\arguments{
\item{dose}{the dose}

\item{model}{the \code{\linkS4class{DualEndpoint}} object}

\item{samples}{the \code{\linkS4class{Samples}} object}

\item{\dots}{unused}

\item{xLevel}{the grid index of \code{dose}}
}
\description{
Compute the biomarker level for a given dose, given model and samples
}
\section{Methods (by class)}{
\itemize{
\item \code{dose = numeric,model = DualEndpoint,samples = Samples}: Here it is very easy, we just return the corresponding
column (index \code{xLevel}) of the biomarker samples matrix, since we save
that in the samples
}}

\examples{

# Create the data
data <- DataDual(
  x=c(0.1, 0.5, 1.5, 3, 6, 10, 10, 10,
      20, 20, 20, 40, 40, 40, 50, 50, 50),
  y=c(0, 0, 0, 0, 0, 0, 1, 0,
      0, 1, 1, 0, 0, 1, 0, 1, 1),
  w=c(0.31, 0.42, 0.59, 0.45, 0.6, 0.7, 0.55, 0.6,
      0.52, 0.54, 0.56, 0.43, 0.41, 0.39, 0.34, 0.38, 0.21),
  doseGrid=c(0.1, 0.5, 1.5, 3, 6,
             seq(from=10, to=80, by=2)))

# Initialize the Dual-Endpoint model (in this case RW1)
model <- DualEndpointRW(mu = c(0, 1),
                        Sigma = matrix(c(1, 0, 0, 1), nrow=2),
                        sigma2betaW = 0.01,
                        sigma2W = c(a=0.1, b=0.1),
                        rho = c(a=1, b=1),
                        smooth = "RW1")

# Set-up some MCMC parameters and generate samples from the posterior
options <- McmcOptions(burnin=100,
                       step=2,
                       samples=500)
set.seed(94)
samples <- mcmc(data, model, options)

# Obtain the biomarker level for a given dose, given model and samples
biomLevel(dose = 0.5,
          model = model,
          samples = samples,
          xLevel = 2)



}
\keyword{methods}
