% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Samples-methods.R
\name{get,Samples,character-method}
\alias{get,Samples,character-method}
\title{Get specific parameter samples and produce a data.frame}
\usage{
\S4method{get}{Samples,character}(x, pos = -1L, envir = NULL, mode = NULL, inherits = NULL)
}
\arguments{
\item{x}{the \code{\linkS4class{Samples}} object}

\item{pos}{the name of the parameter}

\item{envir}{for vectorial parameters, you can give the indices of the
elements you would like to extract. If \code{NULL}, the whole vector samples
will be returned}

\item{mode}{not used}

\item{inherits}{not used}
}
\value{
the data frame suitable for use with \code{\link[ggmcmc]{ggmcmc}}
}
\description{
Here you have to specify with \code{pos} which
parameter you would like to extract from the \code{\linkS4class{Samples}}
object
}
\examples{

# Create some data
data <- Data(x = c(0.1, 0.5, 1.5, 3, 6, 10, 10, 10),
             y = c(0, 0, 0, 0, 0, 0, 1, 0),
             cohort = c(0, 1, 2, 3, 4, 5, 5, 5),
             doseGrid = c(0.1, 0.5, 1.5, 3, 6,
                          seq(from = 10, to = 80, by=2)))

# Initialize a model 
model <- LogisticLogNormal(mean = c(-0.85, 1),
                           cov = matrix(c(1, -0.5, -0.5, 1), nrow = 2),
                           refDose = 56)

# Get posterior for all model parameters
options <- McmcOptions(burnin = 100,
                       step = 2,
                       samples = 2000)
set.seed(94)
samples <- mcmc(data, model, options)

# now extract the alpha0 samples (intercept of the regression model)
alpha0samples <- get(samples, "alpha0")
}
\keyword{methods}
