% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossrunbin.r
\name{crossrunbin}
\alias{crossrunbin}
\title{Joint Distribution for Crossings and Runs}
\usage{
crossrunbin(nmax = 100, prob = 0.5, mult = 2, prec = 120,
  printn = FALSE)
}
\arguments{
\item{nmax}{max sequence length.}

\item{prob}{success probability.}

\item{mult}{multiplier for joint probabilities.}

\item{prec}{mpft precision.}

\item{printn}{logical for progress output.}
}
\value{
list of joint probabilities.
}
\description{
Joint probability distribution for the number of crossings
C and the longest run L in a sequence of n independent Bernoulli observations
with success probability p. To enhance precision, results are stored
in mpfr arrays and the probabilities are multiplied by \eqn{m^{n-1}}
for a multiplier m.
}
\examples{
crb10.6 <- crossrunbin(nmax=10, prob=.6, printn=TRUE)
print(crb10.6$pt[[10]])
}
