% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/officer.R
\name{body_add_title}
\alias{body_add_title}
\title{Add a title to an \code{officer} document}
\usage{
body_add_title(
  doc,
  value,
  level = 1,
  style = getOption("crosstable_style_heading", "heading")
)
}
\arguments{
\item{doc}{the doc object (created with the \code{read_docx} function of \code{officer} package)}

\item{value}{a character string}

\item{level}{the level of the title. See \code{styles_info(doc)} to know the possibilities.}

\item{style}{the name of the title style. See \code{styles_info(doc)} to know the possibilities.}
}
\value{
The docx object \code{doc}
}
\description{
Add a title to an \code{officer} document
}
\examples{
library(officer)
library(crosstable)
library(dplyr)
doc = read_docx()
doc = doc \%>\% 
   body_add_title("La table iris", 1) \%>\% 
   body_add_title("Description", 2) \%>\% 
   body_add_normal("La table iris a ", ncol(iris), " colonnes.")
#write_and_open(doc)
}
\author{
Dan Chaltiel
}
