% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_null.R
\name{compute_null_dnp}
\alias{compute_null_dnp}
\title{function to compute null distribution of dnp}
\usage{
compute_null_dnp(
  cache = NULL,
  df,
  ppi = "biogrid",
  n,
  n_genes = 50,
  experiment_name,
  ncores = 4,
  min_score = NULL
)
}
\arguments{
\item{cache}{user-provided filepath for where to store data etc}

\item{df}{output of \code{\link[=compute_dnp]{compute_dnp()}}}

\item{ppi}{should we use biogrid or stringdb for the PPI}

\item{n}{number of permutations}

\item{n_genes}{integer describing number of genes per sample that we will compute the null distribution for}

\item{experiment_name}{name of the experiment for saving output.}

\item{ncores}{number of cores to use for calculations}

\item{min_score}{if ppi is stringdb, which mininum score should we use to filter edges?}
}
\value{
df, also saves to cache if specified
}
\description{
\code{compute_null_dnp} calculates a null distribution for the change in network potential for
for each node in a cell signaling network.
}
\details{
The input for this function will be the output of \code{\link[=compute_dnp]{compute_dnp()}}.
To compute the null distribution, the nodes in the provided cell signaling
network will be randomly permuted \code{n} times, with dnp computed or each new
cell signaling network. The mean and standard error of dnp for this set of random
networks will constitute the null model that we will use for comparison.
Be warned that this operation is extremely expensive computationally. It is
recommended to either use a high-performance cluster or limit the computation of the
null distribution to a small number of nodes.
To distribute the workload over multiple cores, just specify ncores.
}
\seealso{
\code{\link[=compute_dnp]{compute_dnp()}} and \code{\link[=compute_np]{compute_np()}}
}
