% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{tidy.crumble}
\alias{tidy.crumble}
\title{Tidy a(n) crumble object}
\usage{
\method{tidy}{crumble}(x, ...)
}
\arguments{
\item{x}{A `crumble` object produced by a call to [crumble::crumble()].}

\item{...}{Unused, included for generic consistency only.}
}
\value{
A tidy [tibble::tibble()] summarizing information about the model.
}
\description{
Tidy a(n) crumble object
}
\examples{
\donttest{
if (require("mma") && torch::torch_is_installed()) {
	library(mma)
	data(weight_behavior)

	weight_behavior <- na.omit(weight_behavior)

	res <- crumble(
		data = weight_behavior,
		trt = "sports",
		outcome = "bmi",
		covar = c("age", "sex", "tvhours"),
		mediators = c("exercises", "overweigh"),
		moc = "snack",
		d0 = \(data, trt) factor(rep(1, nrow(data)), levels = c("1", "2")),
		d1 = \(data, trt) factor(rep(2, nrow(data)), levels = c("1", "2")),
		learners = c("mean", "glm"),
		nn_module = sequential_module(),
		control = crumble_control(crossfit_folds = 1L, zprime_folds = 5L, epochs = 10L)
	)

	print(res)
	tidy(res)
}
}
}
