% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/categorical-array.R
\name{prepareBindInputs}
\alias{prepareBindInputs}
\title{Internal function to gather variable URLs for binding}
\usage{
prepareBindInputs(list_of_variables = NULL, dataset = NULL,
  pattern = NULL, key = namekey(dataset), ...)
}
\arguments{
\item{list_of_variables}{a list of Variable objects to bind together, or a
Dataset object containing only the Variables to bind (as in from subsetting
a Dataset), or values (e.g. names) of variables corresponding to \code{key}.
If omitted, must supply \code{dataset} and \code{pattern}. If specifying
values, must include \code{dataset}.}

\item{dataset}{the Crunch Dataset to which the variables in
\code{list_of_variables} belong, or in which to search for variables based
on \code{pattern}. If omitted, \code{list_of_variables} must exist and all
Variables in the list must belong to the same Dataset}

\item{pattern}{An optional regular expression to search for variables to
bind within \code{dataset}.}

\item{key}{character, the name of the Variable field in which to search
with \code{pattern}. Default is 'alias'.}

\item{...}{additional arguments, which are ignored}
}
\value{
a list with two elements: "dataset" and "variable_urls"
}
\description{
Exported only for nonstandard evaluation in makeArray and makeMR
}
\keyword{internal}

