% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{exclusion}
\alias{exclusion}
\alias{exclusion<-}
\title{View and set exclusion filters}
\usage{
exclusion(x)

exclusion(x) <- value
}
\arguments{
\item{x}{a Dataset}

\item{value}{an object of class \code{CrunchLogicalExpr}, or \code{NULL}}
}
\value{
\code{exclusion} returns a \code{CrunchFilter} if there is one,
else \code{NULL}. The setter returns \code{x} with the filter set.
}
\description{
Exclusion filters express logic that defines a set of rows that should be
dropped from the dataset. The rows aren't permanently deleted---you can
recover them at any time by removing the exclusion filter---but they are
omitted from all views and calculations, as if they had been deleted.
}
\details{
Note that exclusion filters work opposite from how "normal" filters work.
That is, a regular filter expression defines the subset of rows to operate
on: it says "keep these rows." An exclusion filter defines which rows to
omit. Applying a filter expression as a query filter will have the
opposite effect if applied as an exclusion. Indeed, applying it as both
query filter and exclusion at the same time will result in 0 rows.
}

