% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.R, R/projects.R, R/shoji.R, R/teams.R,
%   R/variable-delete.R
\docType{methods}
\name{delete}
\alias{delete}
\alias{delete,CrunchDataset-method}
\alias{delete,CrunchProject-method}
\alias{delete,ShojiObject-method}
\alias{delete,ANY-method}
\alias{delete,CrunchTeam-method}
\alias{delete,CrunchVariable-method}
\alias{delete,VariableTuple-method}
\title{Delete a Crunch object from the server}
\usage{
\S4method{delete}{CrunchDataset}(x, ...)

\S4method{delete}{CrunchProject}(x, confirm = requireConsent(), ...)

\S4method{delete}{ShojiObject}(x, ...)

\S4method{delete}{ANY}(x, ...)

\S4method{delete}{CrunchTeam}(x, confirm = requireConsent(), ...)

\S4method{delete}{CrunchVariable}(x, ...)

\S4method{delete}{VariableTuple}(x, confirm = requireConsent(), ...)
}
\arguments{
\item{x}{a Crunch object}

\item{...}{additional arguments, in the generic}

\item{confirm}{logical: should the user be asked to confirm deletion.
Option available for datasets and teams only. Default is \code{TRUE} if in
an interactive session. You can avoid the confirmation prompt if you delete
\code{with(\link{consent})}.}
}
\description{
These methods delete entities, notably Datasets and Variables within them,
from the server. This action is permanent and cannot be undone, so it
should not be done lightly. Consider instead using \code{archive}
for datasets and \code{\link{hide}} for variables
}
\seealso{
\code{\link{hide}} \code{\link{deleteDataset}}
}
