% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine-categories.R
\name{combine}
\alias{combine}
\title{Combine categories or responses}
\usage{
combine(variable, combinations = list(), ...)
}
\arguments{
\item{variable}{Categorical, Categorical Array, or Multiple Response
variable}

\item{combinations}{list of named lists containing
\enumerate{
\item "categories": category ids or names for categorical types, or for multiple response,
"responses": subvariable names, aliases, or positional indices;
\item a "name" for the new category or response; and
\item optionally, other category ("missing", "numeric_value") or subvariable ("alias", "description")
attributes. If \code{combinations} is omitted, the resulting variable will
essentially be a copy (but see \code{\link[=copy]{copy()}} for a more natural way to copy variables.
}}

\item{...}{Additional variable metadata for the new derived variable}
}
\value{
A \code{\link{VariableDefinition}} that will create the new combined-category or
-response derived variable. Categories/responses not referenced in \code{combinations} will be
appended to the end of the combinations.
}
\description{
Crunch allows you to create a new categorical variable by combining
the categories of another variable. For instance, you might want to
recode a categorical variable with three categories small, medium, and large
to one that has just small and large.
}
\examples{
\dontrun{
ds$fav_pet2 <- combine(ds$fav_pet, name="Pets (combined)",
    combinations=list(list(name="Mammals", categories=c("Cat", "Dog")),
                      list(name="Reptiles", categories=c("Snake", "Lizard"))))
ds$pets_owned2 <- combine(ds$allpets, name="Pets owned (collapsed)",
    combinations=list(list(name="Mammals", responses=c("Cat", "Dog"))))
}
}
