% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/subvariables.R
\docType{class}
\name{Subvariables-class}
\alias{Subvariables-class}
\alias{Subvariables}
\alias{subvariables}
\alias{subvariables<-}
\alias{subvariables,CategoricalArrayVariable-method}
\alias{subvariables,CrunchVariable-method}
\alias{subvariables,VariableTuple-method}
\alias{subvariables<-,CategoricalArrayVariable,ANY-method}
\alias{subvariables<-,CategoricalArrayVariable,Subvariables-method}
\title{Subvariables in Array Variables}
\usage{
subvariables(x)

subvariables(x) <- value

\S4method{subvariables}{CategoricalArrayVariable}(x)

\S4method{subvariables}{CrunchVariable}(x)

\S4method{subvariables}{VariableTuple}(x)

\S4method{subvariables}{CategoricalArrayVariable,ANY}(x) <- value

\S4method{subvariables}{CategoricalArrayVariable,Subvariables}(x) <- value
}
\arguments{
\item{x}{A Variable or Subvariables object}

\item{value}{For the setters, the appropriate values to set}
}
\description{
Multiple-response and categorical-array variables are higher order variables which
are made up of sets of subvariables. These methods allow you to retrieve and change
the subvariables of a multiple-response or categorical-array variable.
}
\details{
Subvariables can be accessed from array variables (including multiple
response) with the \code{subvariables} method. They can be assigned back
with the \verb{subvariables<-} setter, but there are limitations to what
is supported. Specifically, you can reorder subvariables, but you cannot
add or remove subvariables by \verb{subvariables<-} assignment. See
\code{\link{deleteSubvariable}} to remove subvariables from an array.

Subvariables have a \code{names} attribute that can be accessed, showing
the display names of the subvariables. These can be set with the
\verb{names<-} method.

Finally, subvariables can be accessed as regular (categorical) variables
with the \code{$} and \code{[[} extract methods.

See the vignette on array variables for further details and examples.
}
\seealso{
\code{\link{describe-catalog}} \code{\link{deleteSubvariable}}
\code{vignette("array-variables", package="crunch")}
}
