% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/decks.R,
%   R/dimension-transforms.R, R/slides.R
\name{filter}
\alias{filter}
\alias{filter<-}
\alias{weight<-,CrunchDeck,ANY-method}
\alias{filter<-,CrunchDeck,ANY-method}
\alias{transforms,CrunchSlide-method}
\alias{transforms,AnalysisCatalog-method}
\alias{transforms,Analysis-method}
\alias{transforms<-,CrunchSlide,ANY-method}
\alias{transforms<-,AnalysisCatalog,ANY-method}
\alias{transforms<-,Analysis,ANY-method}
\alias{analyses}
\alias{analysis}
\alias{analysis<-}
\alias{query<-}
\alias{cube}
\alias{cubes}
\alias{displaySettings}
\alias{displaySettings<-}
\alias{vizSpecs}
\alias{vizSpecs<-}
\alias{analyses,CrunchSlide-method}
\alias{analysis,CrunchSlide-method}
\alias{analysis<-,CrunchSlide,formula-method}
\alias{analysis<-,CrunchSlide,Analysis-method}
\alias{analysis<-,CrunchSlide,list-method}
\alias{filter,CrunchSlide-method}
\alias{filter<-,CrunchSlide,ANY-method}
\alias{query<-,CrunchSlide,ANY-method}
\alias{cubes,CrunchSlide-method}
\alias{cube,CrunchSlide-method}
\alias{displaySettings,CrunchSlide-method}
\alias{displaySettings<-,CrunchSlide,ANY-method}
\alias{vizSpecs,CrunchSlide-method}
\alias{vizSpecs<-,CrunchSlide,ANY-method}
\alias{cubes,AnalysisCatalog-method}
\alias{displaySettings,AnalysisCatalog-method}
\alias{displaySettings<-,AnalysisCatalog,list-method}
\alias{vizSpecs,AnalysisCatalog-method}
\alias{vizSpecs<-,AnalysisCatalog,list-method}
\alias{query<-,Analysis,formula-method}
\alias{formulaToSlideQuery}
\alias{cube,Analysis-method}
\alias{displaySettings,Analysis-method}
\alias{displaySettings<-,Analysis,ANY-method}
\alias{vizSpecs,Analysis-method}
\alias{vizSpecs<-,Analysis,ANY-method}
\alias{filter,Analysis-method}
\alias{filter,ANY-method}
\alias{filter<-,Analysis,CrunchLogicalExpr-method}
\alias{filter<-,Analysis,CrunchFilter-method}
\alias{filter<-,Analysis,NULL-method}
\alias{slideQueryEnv}
\alias{cubes,CrunchDeck-method}
\alias{weight,CrunchSlide-method}
\alias{weight<-,CrunchSlide,ANY-method}
\alias{weight,Analysis-method}
\title{Get and set slide analyses}
\usage{
filter(x, ...)

filter(x) <- value

\S4method{weight}{CrunchDeck,ANY}(x) <- value

\S4method{filter}{CrunchDeck,ANY}(x) <- value

\S4method{transforms}{CrunchSlide}(x)

\S4method{transforms}{AnalysisCatalog}(x)

\S4method{transforms}{Analysis}(x)

\S4method{transforms}{CrunchSlide,ANY}(x) <- value

\S4method{transforms}{AnalysisCatalog,ANY}(x) <- value

\S4method{transforms}{Analysis,ANY}(x) <- value

analyses(x)

analysis(x)

analysis(x) <- value

query(x) <- value

cube(x)

cubes(x)

displaySettings(x)

displaySettings(x) <- value

vizSpecs(x)

vizSpecs(x) <- value

\S4method{analyses}{CrunchSlide}(x)

\S4method{analysis}{CrunchSlide}(x)

\S4method{analysis}{CrunchSlide,formula}(x) <- value

\S4method{analysis}{CrunchSlide,Analysis}(x) <- value

\S4method{analysis}{CrunchSlide,list}(x) <- value

\S4method{filter}{CrunchSlide}(x, ...)

\S4method{filter}{CrunchSlide,ANY}(x) <- value

\S4method{query}{CrunchSlide,ANY}(x) <- value

\S4method{cubes}{CrunchSlide}(x)

\S4method{cube}{CrunchSlide}(x)

\S4method{displaySettings}{CrunchSlide}(x)

\S4method{displaySettings}{CrunchSlide,ANY}(x) <- value

\S4method{vizSpecs}{CrunchSlide}(x)

\S4method{vizSpecs}{CrunchSlide,ANY}(x) <- value

\S4method{cubes}{AnalysisCatalog}(x)

\S4method{displaySettings}{AnalysisCatalog}(x)

\S4method{displaySettings}{AnalysisCatalog,list}(x) <- value

\S4method{vizSpecs}{AnalysisCatalog}(x)

\S4method{vizSpecs}{AnalysisCatalog,list}(x) <- value

\S4method{query}{Analysis,formula}(x) <- value

formulaToSlideQuery(query, dataset)

\S4method{cube}{Analysis}(x)

\S4method{displaySettings}{Analysis}(x)

\S4method{displaySettings}{Analysis,ANY}(x) <- value

\S4method{vizSpecs}{Analysis}(x)

\S4method{vizSpecs}{Analysis,ANY}(x) <- value

\S4method{filter}{Analysis}(x, ...)

\S4method{filter}{ANY}(x, ...)

\S4method{filter}{CrunchSlide,ANY}(x) <- value

\S4method{filter}{Analysis,CrunchLogicalExpr}(x) <- value

\S4method{filter}{Analysis,CrunchFilter}(x) <- value

\S4method{filter}{Analysis,`NULL`}(x) <- value

slideQueryEnv(weight, filter)

\S4method{cubes}{CrunchDeck}(x)

\S4method{weight}{CrunchSlide}(x)

\S4method{weight}{CrunchSlide,ANY}(x) <- value

\S4method{weight}{Analysis}(x)
}
\arguments{
\item{x}{a \code{CrunchSlide}, \code{AnalysisCatalog}, or \code{Analysis}}

\item{...}{ignored}

\item{value}{for the setter, an object to set it}

\item{query}{For \code{formulaToSlideQuery()}, a formula that specifies the query, as in
\code{newSlide()}. See Details of \code{\link[=crtabs]{crtabs()}} for more information.}

\item{dataset}{For \code{formulaToSlideQuery()}, a \code{CrunchDataset} that the variables in
\code{query} refer to.}

\item{weight}{For \code{slideQueryEnv()} a crunch variable to use as a weight or \code{NULL}
to indicate no weight should be used.}

\item{filter}{for \code{slideQueryEnv()}, a \code{CrunchFilter} or \code{CrunchExpression} to filter
the slide.}
}
\description{
Slides are composed of analyses, which are effectively \code{CrunchCubes} with some
additional metadata. You can get and set a slide's Analysis Catalog with the
\code{analyses} method, and access an individual analysis with \code{analysis}. There
are also helpers to get and set the components of the analysis such as \code{filter()},
\code{weight()}, \code{transforms()}, \code{displaySettings()} and \code{vizSpecs()}. You can also
get the \code{CrunchCube} from an analysis using \code{cube()}.
}
\details{
For more complex objects like \code{displaySettings()}, \code{vizSpecs()} and \code{transforms()},
the \href{https://crunch.io/api/reference/#patch-/datasets/-dataset_id-/decks/-deck_id-/slides/-slide_id-/analyses/-analysis_id-/}{API documentation}
provides more details.

Advanced users of the API can assign a list to  \verb{analysis<-} to specify settings
on the analyses that are not otherwise available in \code{rcrunch}. The helpers
\code{formulaToSlideQuery()} and \code{slideQueryEnv()} help you create objects for the
\code{query} and \code{query_environment}.
}
\examples{
\dontrun{
# Examples of setting analysis details (in general these setters work on
# the slide, analysis catalog and analysis, but for brevity the examples only
# show on the slide)

# Change the filter
filter(slide) <- NULL # to remove a filter
filter(slide) <- filters(ds)[["My filter"]]
filter(deck) <- filters(ds)[["My filter"]] # Can set the same filter on a whole deck too

# Change the weight
weight(slide) <- NULL # to remove
weight(slide) <- ds$weight
weight(deck) <- ds$weight # Can set the same weight on a whole deck too

# Change the transforms
transforms(slide) <- list(rows_dimension = makeDimTransform(hide = "Neutral"))

# Change the displaySettings
displaySettings(slide) <- list(vizType = "groupedBarPlot")

# Change the vizSpecs
# viz_specs can get quite long, see
# https://crunch.io/api/reference/#post-/datasets/-dataset_id-/decks/-deck_id-/slides/
vizSpecs(slide) <- viz_specs

# Change the query
#' query(slide) <- ~ cyl + wt
}
}
