% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crypto_history.R
\name{crypto_history}
\alias{crypto_history}
\title{Get historic crypto currency market data}
\usage{
crypto_history(coin = NULL, limit = NULL, start_date = NULL,
  end_date = NULL, coin_list = NULL, sleep = NULL)
}
\arguments{
\item{coin}{string Name, symbol or slug of crypto currency, default is all tokens}

\item{limit}{integer Return the top n records, default is all tokens}

\item{start_date}{string Start date to retrieve data from, format 'yyyymmdd'}

\item{end_date}{string End date to retrieve data from, format 'yyyymmdd'}

\item{coin_list}{string Valid values are 'api', 'static' or NULL}

\item{sleep}{integer Seconds to sleep for between API requests}
}
\value{
Crypto currency historic OHLC market data in a dataframe:
  \item{slug}{Coin url slug}
  \item{symbol}{Coin symbol}
  \item{name}{Coin name}
  \item{date}{Market date}
  \item{ranknow}{Current Rank}
  \item{open}{Market open}
  \item{high}{Market high}
  \item{low}{Market low}
  \item{close}{Market close}
  \item{volume}{Volume 24 hours}
  \item{market}{USD Market cap}
  \item{close_ratio}{Close rate, min-maxed with the high and low values that day}
  \item{spread}{Volatility premium, high minus low for that day}

This is the main function of the crypto package. If you want to retrieve
ALL coins then do not pass a argument to crypto_history(), or pass the coin name.
}
\description{
Scrape the crypto currency historic market tables from
CoinMarketCap <https://coinmarketcap.com> and display
the results in a date frame. This can be used to conduct
analysis on the crypto financial markets or to attempt
to predict future market movements or trends.
}
\examples{
\dontrun{

# Retrieving market history for ALL crypto currencies
all_coins <- crypto_history(limit = 1)

# Retrieving this years market history for ALL crypto currencies
all_coins <- crypto_history(start_date = '20180101')
}
}
