% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_indicators.R
\name{addFGIndex}
\alias{addFGIndex}
\title{Chart the Fear and Greed Index}
\usage{
addFGIndex(chart, FGI)
}
\arguments{
\item{chart}{a \code{\link[=kline]{kline()}} or \code{\link[=ohlc]{ohlc()}} chart}

\item{FGI}{The Fear and Greed Index created by \code{\link[=getFGIndex]{getFGIndex()}}}
}
\value{
Invisbly returns a plotly object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

The fear and greed index is a market sentiment indicator that measures investor emotions to
gauge whether they are generally fearful (indicating potential selling pressure) or greedy (indicating potential buying enthusiasm)
}
\details{
The Fear and Greed Index goes from 0-100, and can be classifed as follows

\itemize{
\item 0-24, Extreme Fear
\item 25-44, Fear
\item 45-55, Neutral
\item 56-75, Greed
\item 76-100, Extreme Greed
}
}
\examples{
# script: Fear and Greed Index
# date: 2023-12-26
# author: Serkan Korkmaz, serkor1@duck.com
# objective: Retrieve and Plot the
# index
# script start;

# 1) get the fear and greed index
# over time
FGI <- try(
  cryptoQuotes::getFGIndex()
)

# 2) get BTCUSDT-pair on
# daily
BTCUSDT <- try(
  cryptoQuotes::getQuote(
    ticker = 'BTCUSDT',
    interval = '1d',
    futures = FALSE
  )
)

# 3) chart the klines
# of BTCUSDT with
# the Fear and Greed Index
if (!inherits(BTCUSDT, 'try-error') & !inherits(FGI, 'try-error')) {

  cryptoQuotes::chart(
    chart = cryptoQuotes::kline(
      BTCUSDT
    ) \%>\% cryptoQuotes::addFGIndex(
      FGI = FGI
    ),
    slider = FALSE
  )

}

# script end;
}
\seealso{
Other chart indicators: 
\code{\link{addBBands}()},
\code{\link{addEvents}()},
\code{\link{addLSRatio}()},
\code{\link{addMACD}()},
\code{\link{addMA}()},
\code{\link{addRSI}()},
\code{\link{addVolume}()},
\code{\link{chart}()}
}
\concept{chart indicators}
