% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_new_transactions.R
\name{check_new_transactions}
\alias{check_new_transactions}
\title{Check for new transactions}
\usage{
check_new_transactions(
  data,
  known.transactions,
  transactions.col,
  description.col = NULL
)
}
\arguments{
\item{data}{The dataframe}

\item{known.transactions}{A list of known transactions}

\item{transactions.col}{The name of the transaction column}

\item{description.col}{The name of the description column,
if available.}
}
\value{
A warning, if there are new transactions. Returns
nothing otherwise.
}
\description{
Check for new transactions for a given exchange
}
\examples{
data <- data_CDC[1:5, ]
known.transactions <- c("crypto_purchase", "lockup_lock")
check_new_transactions(data, 
                       known.transactions = known.transactions,
                       transactions.col = "Transaction.Kind",
                       description.col = "Transaction.Description")
}
