% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coinmarketcap.R
\name{coinmarketcap_id_map}
\alias{coinmarketcap_id_map}
\title{coinmarketcap_id_map}
\usage{
coinmarketcap_id_map(
  api_key,
  listing_status = "active",
  start = "1",
  limit = NULL,
  sort = "id",
  symbol = NULL,
  aux = "platform,first_historical_data,last_historical_data,is_active,status"
)
}
\arguments{
\item{api_key}{your CoinMarketCap API key}

\item{listing_status}{you can choose "active", "inactive", or "untracked".
Multiple options can be passed if they are comma-separated. Choosing "active"
will return only active cryptocurrencies. Choosing "inactive" will return
cryptocurrencies which are inactive. Choosing "untracked" will return a list
of cryptocurrencies which are listed by CoinMarketCap but do not yet meet
their methodology requirements to have tracked markets available. The default
is "active".}

\item{start}{you can use this parameter to offset your first result. The
default value is "1".}

\item{limit}{an optional string value between 1 and 5000 which tells
CoinMarketCap how many results to return. The default value is NULL.}

\item{sort}{the field used to sort your results. The two acceptable values
are "id" and "cmc_rank". The default value is "id".}

\item{symbol}{Optionally pass a comma-separated list of cryptocurrency
symbols to return CoinMarketCap IDs for. The default value is NULL.}

\item{aux}{Optionally specify a comma-separated list of supplemental data
fields to return. Pass "platform,first_historical_data,last_historical_data,
is_active,status" to include all auxiliary fields. This function will include
all auxiliary fields by default.}
}
\value{
returns a dataframe which includes the id mapping for CoinMarketCap
cryptocurrencies along with other metadata related to the currencies.
}
\description{
coinmarketcap_id_map
}
\examples{
\dontrun{
api_key <- "..."
id_map <- coinmarketcap_id_map(api_key)}
}
