import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.io.DriverProperties;
import com.vividsolutions.jump.io.ShapefileReader;
import com.vividsolutions.jump.io.ShapefileWriter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;

/**
 * Code to test the polygon simplification
 * Nils B. Weidmann (nils.weidmann@gmail.com)
 */
public class CShapesSimplifier {

    private FeatureCollection fc;
    private String packageHome = "/Users/nilsw/Projects/CShapes/Final/";

    public void run() {

        // read the shapefile
		fc = null;
		try {
			File file = new File(packageHome, "cshapes.shp");
			DriverProperties dp = new DriverProperties(file.getAbsolutePath());
			fc = (new ShapefileReader()).read(dp);
		} catch (Exception e) {
			e.printStackTrace();
		}

        FeatureCollection fcnew = new FeatureDataset(fc.getFeatureSchema());
		Iterator it = fc.iterator();

        while (it.hasNext()) {

            Feature f = (Feature) it.next();
            Geometry simpleGeometry = TopologyPreservingSimplifier.simplify(f.getGeometry(), 0.1);
            f.setGeometry(simpleGeometry);
            fcnew.add(f);
        }

        try {
			File file = new File(packageHome, "cshapes_simple.shp");
			DriverProperties dp = new DriverProperties(file.getAbsolutePath());
			(new ShapefileWriter()).write(fcnew, dp);
		} catch (Exception e) {
			e.printStackTrace();
		}
    }


    public static void main(String[] args) {
        CShapesSimplifier s = new CShapesSimplifier();
        s.run();
    }


}
