% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cDistance.R
\name{cDistance}
\alias{cDistance}
\title{Selection of number of clusters via distance-based measures}
\usage{
cDistance(data, kseq, method = "kmeans", linkage = "complete",
  kmIter = 10, gapIter = 10)
}
\arguments{
\item{data}{a n x p data matrix of type numeric.}

\item{kseq}{a vector with considered numbers clusters k > 1}

\item{method}{character string indicating the clustering algorithm. 'kmeans' for the
k-means algorithm, 'hierarchical' for hierarchical clustering.}

\item{linkage}{character specifying the linkage criterion, in case
\code{type='hierarchical'}. The available options are "single", "complete",
"average", "mcquitty", "ward.D", "ward.D2", "centroid" or "median". See
\link[stats]{hclust}.}

\item{kmIter}{integer specifying the the number of restarts of the k-means algorithm
in order to avoid local minima.}

\item{gapIter}{integer specifying the number of simulated datasets to compute the
\emph{gap statistic} (see Tibshirani et al., 2001).}
}
\value{
a list with the optimal numbers of cluster determined by the \emph{gap statistic}
   (Tibshirani et al., 2001), the \emph{jump Statistic} (Sugar & James, 2011) and the
   \emph{slope statistic} (Fujita et al., 2014). Along the function returns the \emph{gap},
   \emph{jump} and \code{slope} for each k in \code{kseq}.
}
\description{
Selection of number of clusters via \emph{gap statistic}, \emph{jump statistic}, and
   \emph{slope statistic}
}
\examples{
\dontrun{
  # Generate Data from Gaussian Mixture
  s <- .1
  n <- 50
  data <- rbind(cbind(rnorm(n, 0, s), rnorm(n, 0, s)),
                cbind(rnorm(n, 1, s), rnorm(n, 1, s)),
                cbind(rnorm(n, 0, s), rnorm(n, 1, s)),
                cbind(rnorm(n, 1, s), rnorm(n, 0, s)))
  plot(data)

 # Selection of Number of Clusters using Distance-based Measures
 cDistance(data, kseq=2:10)
 }

}
\author{
Dirk U. Wulff <dirk.wulff@gmail.com>
  Jonas M. B. Haslbeck  <jonas.haslbeck@gmail.com>
}
\references{
Tibshirani, R., Walther, G., & Hastie, T. (2001). Estimating the number of clusters in a
  data set via the gap statistic. \emph{Journal of the Royal Statistical Society: Series B
  (Statistical Methodology), 63}(2), 411-423.

  Sugar, C. A., & James, G. M. (2011). Finding the number of clusters in a dataset. \emph{Journal
  of the American Statistical Association, 98}(463), 750-763,

  Fujita, A., Takahashi, D. Y., & Patriota, A. G. (2014). A non-parametric method to estimate
  the number of clusters. \emph{Computational Statistics & Data Analysis, 73}, 27-39.
}

